/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Plane(Vec3 pos, Vec3 normal) {
    public Plane(Vec3 pos, Vec3 normal) {
        this.pos = pos;
        this.normal = normal.m_82541_();
    }

    public double getDistanceTo(Vec3 point) {
        return this.normal.m_82526_(point.m_82546_(this.pos));
    }

    public double getDistanceTo(double x, double y, double z) {
        return this.normal.m_7096_() * (x - this.pos.m_7096_()) + this.normal.m_7098_() * (y - this.pos.m_7098_()) + this.normal.m_7094_() * (z - this.pos.m_7094_());
    }

    @NotNull
    public Vec3 getProjection(Vec3 point) {
        return point.m_82546_(this.normal.m_82490_(this.getDistanceTo(point)));
    }

    public Vec3 getReflection(Vec3 point) {
        return point.m_82546_(this.normal.m_82490_(2.0 * this.getDistanceTo(point)));
    }

    public boolean isPointOnPositiveSide(Vec3 point) {
        return this.getDistanceTo(point) > 0.0;
    }

    public Plane move(double distance) {
        return new Plane(this.pos.m_82549_(this.normal.m_82490_(distance)), this.normal);
    }

    public Plane getOpposite() {
        return new Plane(this.pos, this.normal.m_82490_(-1.0));
    }

    @Nullable
    public Vec3 rayTrace(Vec3 origin, Vec3 vec) {
        double t = this.rayTraceGetT(origin, vec);
        if (Double.isNaN(t)) {
            return null;
        }
        if (t < 0.0) {
            return null;
        }
        return origin.m_82549_(vec.m_82490_(t));
    }

    public double rayTraceGetT(Vec3 lineOrigin, Vec3 lineVec) {
        double lineVecProjectToNormal = this.normal.m_82526_(lineVec);
        if (Math.abs(lineVecProjectToNormal) < 1.0E-5) {
            return Double.NaN;
        }
        return -this.getDistanceTo(lineOrigin) / lineVecProjectToNormal;
    }

    public double rayTraceGetT(double lineOriginX, double lineOriginY, double lineOriginZ, double lineVecX, double lineVecY, double lineVecZ) {
        double lineVecProjectToNormal = this.normal.m_7096_() * lineVecX + this.normal.m_7098_() * lineVecY + this.normal.m_7094_() * lineVecZ;
        if (Math.abs(lineVecProjectToNormal) < 1.0E-5) {
            return Double.NaN;
        }
        return -this.getDistanceTo(lineOriginX, lineOriginY, lineOriginZ) / lineVecProjectToNormal;
    }

    @Nullable
    public Vec3 intersectionWithLineSegment(Vec3 lineP1, Vec3 lineP2) {
        Vec3 lineVec = lineP2.m_82546_(lineP1);
        double t = this.rayTraceGetT(lineP1, lineVec);
        if (Double.isNaN(t)) {
            return null;
        }
        if (t < 0.0 || t > 1.0) {
            return null;
        }
        return lineP1.m_82549_(lineVec.m_82490_(t));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plane plane = (Plane)o;
        return this.pos.equals((Object)plane.pos) && this.normal.equals((Object)plane.normal);
    }

    @Override
    public String toString() {
        return "Plane{pos=" + String.valueOf(this.pos) + ", normal=" + String.valueOf(this.normal) + "}";
    }

    public static Plane interpolate(Plane a, Plane b, double progress) {
        Vec3 pos = a.pos.m_165921_(b.pos, progress);
        Vec3 normal = a.normal.m_165921_(b.normal, progress);
        return new Plane(pos, normal);
    }

    public Plane getParallelPlane(Vec3 pos) {
        return new Plane(pos, this.normal);
    }
}

